<?php //46c9f5381c2e9403b6ea5f8ff1810052
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_Category_C;
    use LaravelIdea\Helper\App\Models\_IH_Category_QB;
    use LaravelIdea\Helper\App\Models\_IH_Customer_C;
    use LaravelIdea\Helper\App\Models\_IH_Customer_QB;
    use LaravelIdea\Helper\App\Models\_IH_Location_C;
    use LaravelIdea\Helper\App\Models\_IH_Location_QB;
    use LaravelIdea\Helper\App\Models\_IH_Manager_C;
    use LaravelIdea\Helper\App\Models\_IH_Manager_QB;
    use LaravelIdea\Helper\App\Models\_IH_MenuItem_C;
    use LaravelIdea\Helper\App\Models\_IH_MenuItem_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderMenuItemToppings_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderMenuItemToppings_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderMenuItem_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderMenuItem_QB;
    use LaravelIdea\Helper\App\Models\_IH_Order_C;
    use LaravelIdea\Helper\App\Models\_IH_Order_QB;
    use LaravelIdea\Helper\App\Models\_IH_Restaurant_C;
    use LaravelIdea\Helper\App\Models\_IH_Restaurant_QB;
    use LaravelIdea\Helper\App\Models\_IH_Review_C;
    use LaravelIdea\Helper\App\Models\_IH_Review_QB;
    use LaravelIdea\Helper\App\Models\_IH_Table_C;
    use LaravelIdea\Helper\App\Models\_IH_Table_QB;
    use LaravelIdea\Helper\App\Models\_IH_Topping_C;
    use LaravelIdea\Helper\App\Models\_IH_Topping_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    use LaravelIdea\Helper\Spatie\MediaLibrary\MediaCollections\Models\_IH_Media_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Spatie\MediaLibrary\MediaCollections\Models\Collections\MediaCollection;
    use Spatie\MediaLibrary\MediaCollections\Models\Media;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;

    /**
     * @property _IH_MenuItem_C|MenuItem[] $menuItems
     * @property-read int $menu_items_count
     * @method HasMany|_IH_MenuItem_QB menuItems()
     * @method static _IH_Category_QB onWriteConnection()
     * @method _IH_Category_QB newQuery()
     * @method static _IH_Category_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Category_QB query()
     * @method static _IH_Category_QB with(array|string $relations)
     * @method _IH_Category_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Category_C|Category[] all($columns = ['*'])
     * @mixin _IH_Category_QB
     */
    class Category extends Model {}

    /**
     * @property _IH_Restaurant_C|Restaurant[] $restaurants
     * @property-read int $restaurants_count
     * @method BelongsToMany|_IH_Restaurant_QB restaurants()
     * @method static _IH_Customer_QB onWriteConnection()
     * @method _IH_Customer_QB newQuery()
     * @method static _IH_Customer_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Customer_QB query()
     * @method static _IH_Customer_QB with(array|string $relations)
     * @method _IH_Customer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Customer_C|Customer[] all($columns = ['*'])
     * @mixin _IH_Customer_QB
     */
    class Customer extends Model {}

    /**
     * @property Restaurant $restaurant
     * @method BelongsTo|_IH_Restaurant_QB restaurant()
     * @method static _IH_Location_QB onWriteConnection()
     * @method _IH_Location_QB newQuery()
     * @method static _IH_Location_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Location_QB query()
     * @method static _IH_Location_QB with(array|string $relations)
     * @method _IH_Location_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Location_C|Location[] all($columns = ['*'])
     * @mixin _IH_Location_QB
     */
    class Location extends Model {}

    /**
     * @method static _IH_Manager_QB onWriteConnection()
     * @method _IH_Manager_QB newQuery()
     * @method static _IH_Manager_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Manager_QB query()
     * @method static _IH_Manager_QB with(array|string $relations)
     * @method _IH_Manager_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Manager_C|Manager[] all($columns = ['*'])
     * @mixin _IH_Manager_QB
     */
    class Manager extends Model {}

    /**
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property MediaCollection|Media[] $media
     * @property-read int $media_count
     * @method MorphToMany|_IH_Media_QB media()
     * @property Restaurant $restaurant
     * @method BelongsTo|_IH_Restaurant_QB restaurant()
     * @property _IH_Review_C|Review[] $reviews
     * @property-read int $reviews_count
     * @method HasMany|_IH_Review_QB reviews()
     * @property _IH_Topping_C|Topping[] $toppings
     * @property-read int $toppings_count
     * @method BelongsToMany|_IH_Topping_QB toppings()
     * @method static _IH_MenuItem_QB onWriteConnection()
     * @method _IH_MenuItem_QB newQuery()
     * @method static _IH_MenuItem_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_MenuItem_QB query()
     * @method static _IH_MenuItem_QB with(array|string $relations)
     * @method _IH_MenuItem_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MenuItem_C|MenuItem[] all($columns = ['*'])
     * @mixin _IH_MenuItem_QB
     */
    class MenuItem extends Model {}

    /**
     * @property Customer $customer
     * @method BelongsTo|_IH_Customer_QB customer()
     * @property Location $location
     * @method BelongsTo|_IH_Location_QB location()
     * @property _IH_MenuItem_C|MenuItem[] $menuItems
     * @property-read int $menu_items_count
     * @method BelongsToMany|_IH_MenuItem_QB menuItems()
     * @property _IH_OrderMenuItem_C|OrderMenuItem[] $orderItems
     * @property-read int $order_items_count
     * @method HasMany|_IH_OrderMenuItem_QB orderItems()
     * @property Restaurant $restaurant
     * @method BelongsTo|_IH_Restaurant_QB restaurant()
     * @property Table $table
     * @method BelongsTo|_IH_Table_QB table()
     * @method static _IH_Order_QB onWriteConnection()
     * @method _IH_Order_QB newQuery()
     * @method static _IH_Order_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Order_QB query()
     * @method static _IH_Order_QB with(array|string $relations)
     * @method _IH_Order_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Order_C|Order[] all($columns = ['*'])
     * @mixin _IH_Order_QB
     */
    class Order extends Model {}

    /**
     * @property MenuItem $menuItem
     * @method BelongsTo|_IH_MenuItem_QB menuItem()
     * @property Order $order
     * @method BelongsTo|_IH_Order_QB order()
     * @property _IH_OrderMenuItemToppings_C|OrderMenuItemToppings[] $toppings
     * @property-read int $toppings_count
     * @method HasMany|_IH_OrderMenuItemToppings_QB toppings()
     * @method static _IH_OrderMenuItem_QB onWriteConnection()
     * @method _IH_OrderMenuItem_QB newQuery()
     * @method static _IH_OrderMenuItem_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OrderMenuItem_QB query()
     * @method static _IH_OrderMenuItem_QB with(array|string $relations)
     * @method _IH_OrderMenuItem_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderMenuItem_C|OrderMenuItem[] all($columns = ['*'])
     * @mixin _IH_OrderMenuItem_QB
     */
    class OrderMenuItem extends Model {}

    /**
     * @property OrderMenuItem $orderMenuItem
     * @method BelongsTo|_IH_OrderMenuItem_QB orderMenuItem()
     * @property Topping $topping
     * @method BelongsTo|_IH_Topping_QB topping()
     * @method static _IH_OrderMenuItemToppings_QB onWriteConnection()
     * @method _IH_OrderMenuItemToppings_QB newQuery()
     * @method static _IH_OrderMenuItemToppings_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OrderMenuItemToppings_QB query()
     * @method static _IH_OrderMenuItemToppings_QB with(array|string $relations)
     * @method _IH_OrderMenuItemToppings_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderMenuItemToppings_C|OrderMenuItemToppings[] all($columns = ['*'])
     * @mixin _IH_OrderMenuItemToppings_QB
     */
    class OrderMenuItemToppings extends Model {}

    /**
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Restaurant_QB onWriteConnection()
     * @method _IH_Restaurant_QB newQuery()
     * @method static _IH_Restaurant_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Restaurant_QB query()
     * @method static _IH_Restaurant_QB with(array|string $relations)
     * @method _IH_Restaurant_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Restaurant_C|Restaurant[] all($columns = ['*'])
     * @mixin _IH_Restaurant_QB
     */
    class Restaurant extends Model {}

    /**
     * @method static _IH_Review_QB onWriteConnection()
     * @method _IH_Review_QB newQuery()
     * @method static _IH_Review_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Review_QB query()
     * @method static _IH_Review_QB with(array|string $relations)
     * @method _IH_Review_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Review_C|Review[] all($columns = ['*'])
     * @mixin _IH_Review_QB
     */
    class Review extends Model {}

    /**
     * @property Location $location
     * @method BelongsTo|_IH_Location_QB location()
     * @property Restaurant $restaurant
     * @method BelongsTo|_IH_Restaurant_QB restaurant()
     * @method static _IH_Table_QB onWriteConnection()
     * @method _IH_Table_QB newQuery()
     * @method static _IH_Table_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Table_QB query()
     * @method static _IH_Table_QB with(array|string $relations)
     * @method _IH_Table_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Table_C|Table[] all($columns = ['*'])
     * @mixin _IH_Table_QB
     */
    class Table extends Model {}

    /**
     * @property _IH_MenuItem_C|MenuItem[] $menuItems
     * @property-read int $menu_items_count
     * @method BelongsToMany|_IH_MenuItem_QB menuItems()
     * @method static _IH_Topping_QB onWriteConnection()
     * @method _IH_Topping_QB newQuery()
     * @method static _IH_Topping_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Topping_QB query()
     * @method static _IH_Topping_QB with(array|string $relations)
     * @method _IH_Topping_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Topping_C|Topping[] all($columns = ['*'])
     * @mixin _IH_Topping_QB
     */
    class Topping extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property mixed $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Customer $customer
     * @method HasOne|_IH_Customer_QB customer()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Restaurant_C|Restaurant[] $restaurants
     * @property-read int $restaurants_count
     * @method BelongsToMany|_IH_Restaurant_QB restaurants()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all($columns = ['*'])
     * @foreignLinks
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}
}
